-- todo?: the old SM5 ThemePref stuff works, but what about the Module-based one in SM5.3?

-- StepMania 5 Default Theme Preferences Handler
local function OptionNameString(str)
	return THEME:GetString('OptionNames',str)
end

-- "Example usage of new system (not fully implemented)" - SM5 Default Theme, 20XX
local Prefs =
{
	-- Default carryovers.
	-- TODO: figure out which ones we don't need.
	AutoSetStyle =
	{
		Default = false,
		Choices = { OptionNameString('Off'), OptionNameString('On') },
		Values = { false, true }
	},
	ShowLotsaOptions =
	{
		Default = true,
		Choices = { OptionNameString('Many'), OptionNameString('Few') },
		Values = { true, false }
	},
	ComboOnRolls =
	{
		Default = false,
		Choices = { OptionNameString('Off'), OptionNameString('On') },
		Values = { false, true }
	},
	FlashyCombo =
	{
		Default = false,
		Choices = { OptionNameString('Off'), OptionNameString('On') },
		Values = { false, true }
	},
	ComboUnderField =
	{
		Default = true,
		Choices = { OptionNameString('Off'), OptionNameString('On') },
		Values = { false, true }
	},
	FancyUIBG =
	{
		Default = false,
		Choices = { OptionNameString('Off'), OptionNameString('On') },
		Values = { false, true }
	},
	
	JudgmentsUnderField =
	{
		Default = false,
		Choices = { OptionNameString('Off'), OptionNameString('On') },
		Values = { false, true }
	},
	
	-- New stuff:
	-- Discord status stalker control.
	DiscordStatusfication =
	{
		Default = "none",
		Choices = { OptionNameString('DiStaNone'), OptionNameString('DiStaSome'), OptionNameString('DiStaAll') },
		Values = { "none", "some", "all" }
	},
	
	-- Touchy technical stuff:
	-- Minimum judgment needed to increment a combo
	CustomComboContinue =
	{
		Default = "auto",
		Choices = { OptionNameString('Auto'), OptionNameString('TNS_W1'), OptionNameString('TNS_W2'), OptionNameString('TNS_W3'), OptionNameString('TNS_W4')  },
		Values = { "auto", "TapNoteScore_W1", "TapNoteScore_W2", "TapNoteScore_W3", "TapNoteScore_W4" }
	},
	-- Minimum judgment needed to maintain (without incrementing) a combo
	CustomComboMaintain =
	{
		Default = "auto",
		Choices = { OptionNameString('Auto'), OptionNameString('TNS_W1'), OptionNameString('TNS_W2'), OptionNameString('TNS_W3'), OptionNameString('TNS_W4')  },
		Values = { "auto", "TapNoteScore_W1", "TapNoteScore_W2", "TapNoteScore_W3", "TapNoteScore_W4" }
	},
}

ThemePrefs.InitAll(Prefs)

-- local function DefaultLifeBarType()
	-- return GAMESTATE:GetCurrentGame():GetName() == "para" and "default" or "fallback"
-- end

-- Make this separate because we might need to reset only one player's envs.
function InitOnePlayerPrefs(pn)
	for i, op in ipairs(LoadModule("Options.Envs.lua")) do
		setenv(op[1] .. ToEnumShortString(pn), op[2])
	end
end

-- Let's... maybe make a bit more out of this.
-- (see also: 21 ProfileManagement.lua)
-- todo: use setenv and getenv more...?
function InitUserPrefs()
	-- Run through every available player and (re)set certain env values.
	for i, pn in ipairs(PlayerNumber) do
		InitOnePlayerPrefs(pn)
	end
	
	-- Set less player-specific stuff while we're here.
	SwitchToFreestyle()
	THEME_EKSDBGVidMode = "default"
end
